local itemFont = "_eurostile bold 24px"

local function MakeLabel(text)
	return LoadFont(itemFont)..{
		InitCommand=cmd(uppercase,true;shadowlength,2;zoom,0.5;diffusealpha,0.5);
		BeginCommand=cmd(settext,text);
	};
end

return Def.ActorFrame{
	InitCommand=cmd(fov,64);
	Def.ActorFrame{
		Name="ArtistFrame";
		InitCommand=cmd(x,-156;);
		MakeLabel("Artist")..{
			InitCommand=cmd(halign,0;);
		};
		LoadFont(itemFont)..{
			-- old maxwidth:420
			InitCommand=cmd(y,16;shadowlength,2;zoom,0.75;halign,0;diffusealpha,0.9;maxwidth,420*0.625);
			BeginCommand=cmd(playcommand,"Set");
			SetCommand=function(self)
				local song = SongOrCourse()
				local artist = ""
				if song then
					artist = song:GetDisplayArtist()
				end
				self:settext(artist)
			end;
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
		};
	};
	Def.ActorFrame{
		Name="BPMFrame";
		InitCommand=cmd(x,156;);
		MakeLabel("BPM")..{
			InitCommand=cmd(y,-1;halign,1;);
		};
		LoadFont(itemFont)..{
			InitCommand=cmd(y,15;shadowlength,2;zoom,0.75;halign,1;diffusealpha,0.9;maxwidth,420);
			BeginCommand=cmd(playcommand,"Set");
			SetCommand=function(self)
				local songCourse = SongOrCourse()
				local val
				if songCourse then
					local bpms = songCourse:GetDisplayBpms()

					if bpms[1] == bpms[2] then
						val = string.format("%i",bpms[1])
					else
						val = string.format("%i-%i",bpms[1],bpms[2])
					end
				else
					val = ""
				end
				self:settext(val)
			end;
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
		};
	};

	Def.Quad{
		InitCommand=cmd(xy,6,28;zoomto,338,2;diffusealpha,0.35);
	};
};